/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.cutpointSelection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.rules.lad.core.BinaryData;
import weka.classifiers.rules.lad.core.BinaryInstance;
import weka.classifiers.rules.lad.cutpointSelection.FeatureSelection;
import weka.classifiers.rules.lad.setCovering.SetCovering;
import weka.core.Option;
import weka.core.Utils;

public class GreedySetCover
extends FeatureSelection {
    private static final long serialVersionUID = 1L;

    @Override
    public void findSelectedAtts(BinaryData bInsts) {
        this.mSelectedAttArray = new ArrayList();
        if (this.mSeparationLevel <= 0) {
            int i = 0;
            while (i < bInsts.numAttributes()) {
                this.mSelectedAttArray.add(i);
                ++i;
            }
            return;
        }
        int numSets = bInsts.numAttributes();
        ArrayList<Integer> array = new ArrayList<Integer>(numSets);
        SetCovering sc = new SetCovering(numSets);
        for (BinaryInstance pInst : bInsts.getPositiveInstances()) {
            for (BinaryInstance nInst : bInsts.getNegativeInstances()) {
                array.clear();
                int c = 0;
                while (c < numSets) {
                    if (!pInst.compareAtt(c, nInst)) {
                        array.add(c);
                    }
                    ++c;
                }
                sc.addElement(array);
            }
        }
        sc.solve(this.mSeparationLevel);
        this.mSelectedAttArray = sc.getSolution();
        Collections.sort(this.mSelectedAttArray);
    }

    @Override
    public String globalInfo() {
        return "Implements Chv\u00e1tal's greedy algorithm for solving the Set Cover instance arising during standard LAD binarization.";
    }

    @Override
    public String separationLevelTipText() {
        return "Separation requirement for feature selection. Every pair of observations must be separated by a minimum number of binary features.";
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-fsl");
        options.add("" + this.getSeparationLevel());
        return options.toArray(new String[options.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String featureSelSeparationLevelOption = Utils.getOption("fsl", options);
        if (featureSelSeparationLevelOption.length() != 0) {
            this.setSeparationLevel(Integer.parseInt(featureSelSeparationLevelOption));
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tFeature selection separation level. How many times each\n\tpair of observations should be separated by cutpoints.\n\t(Default = 0, i.e., no separation required)", "fsl", 1, "-fsl <separation_level>"));
        return newVector.elements();
    }
}

